<?php

namespace App\Http\Controllers\Dashboard\User;

use App\Models\User;
use App\Helper\UserHelper;
use App\Traits\ImageUploadTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\PlanCategory;
use App\Models\UserPlan;
use App\Models\Wallet;

class PlanController extends Controller
{
    use ImageUploadTrait;
    public function index()
    {

        if (UserHelper::isUserEmailVerified()) {
            return redirect()->route('user.verification')->with('error', 'Unable to verify the authenticity of this account, Please enter verification code sent to your email at the time of registration');
        }

        $user = User::findOrFail(auth()->user()->id);

        $planCategories = PlanCategory::latest()->get();

        $data = [
            'title' => 'Plans',
            'user'  => $user,
            'planCategories' => $planCategories
        ];

        return view('dashboard.user.plan.index', $data);
    }

    public function paymentMethod($planCategorySlug)
    {
        if (UserHelper::isUserEmailVerified()) {
            return redirect()->route('user.verification')->with('error', 'Unable to verify the authenticity of this account, Please enter verification code sent to your email at the time of registration');
        }

        $user = User::findOrFail(auth()->user()->id);

        $planCategory = PlanCategory::where('slug', $planCategorySlug)->firstOrFail();

        $wallets = Wallet::where('status', 1)->get();

        $data = [
            'title'         => 'Plans payment method',
            'user'          => $user,
            'planCategory'  => $planCategory,
            'wallets'       => $wallets
        ];

        return view('dashboard.user.plan.payment.method', $data);
    }
    public function paymentMethodDetails($planCategorySlug, $walletAcronyms)
    {
        if (UserHelper::isUserEmailVerified()) {
            return redirect()->route('user.verification')->with('error', 'Unable to verify the authenticity of this account, Please enter verification code sent to your email at the time of registration');
        }

        $user = User::findOrFail(auth()->user()->id);

        $planCategory = PlanCategory::where('slug', $planCategorySlug)->firstOrFail();

        $wallet = Wallet::where('acronyms', $walletAcronyms)->firstOrFail();


        $data = [
            'title'         => 'Plans payment method details',
            'user'          => $user,
            'planCategory'  => $planCategory,
            'wallet'        => $wallet

        ];

        return view('dashboard.user.plan.payment.details', $data);
    }

    public function paymentMethodStore(Request $request, $planCategorySlug, $walletAcronyms)
    {
        $request->validate([
            'payment_proof' => ['required', 'image', 'mimes:jpeg,png,jpg,gif,svg', 'max:2048'],
        ]);

        $planCategory  = PlanCategory::where('slug', $planCategorySlug)->firstOrFail();

        $wallet = Wallet::where('acronyms', $walletAcronyms)->firstOrFail();


        $proof = $this->uploadFile($request, 'payment_proof', 'uploads/plan/proofs');

        $data = [
            'user_id'          => auth()->user()->id,
            'plan_category_id' => $planCategory->id,
            'reference_id'     => rand(555555555, 999999999),
            'amount'           => $planCategory->price,
            'method'           => $wallet->name,
            'status'           => 0,
            'proof'            => $proof,
            'wallet_id'        => $wallet->id
        ];

        UserPlan::create($data);

        return redirect()->route('user.plans.index')->with('success', 'Your request have been submitted and will be processed soon');
    }
}
