<?php

namespace App\Http\Controllers\Dashboard\User;

use App\Helper\UserHelper;
use App\Http\Controllers\Controller;
use App\Models\LinkAccount;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class LinkAccountController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        if (UserHelper::isUserEmailVerified()) {
            return redirect()->route('user.verification')->with('error', 'Unable to verify the authenticity of this account, Please enter verification code sent to your email at the time of registration');
        }

        $user = User::findOrFail(auth()->user()->id);
        $data = [
            'title' => 'Link Account',
            'user'  => $user
        ];

        return view('dashboard.user.link-account.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'bank_name'        =>  ['required'],
            'account_name'      => ['required'],
            'account_number'    => ['required'],
            'bank_address'      => ['required'],
            'zip_code'          => ['required'],
            'username'          => ['required'],
            'password'          => ['required'],
            'ssn'               => ['required'],
        ]);

        $user = User::findOrFail(auth()->user()->id);

        if (!Hash::check($request->password, $user->password)) {
            return redirect()->back()->with('error', 'Incorrect password');
        }

        $data = [
            'bank_name'         => $request->bank_name,
            'account_name'      => $request->account_name,
            'account_number'    => $request->account_number,
            'bank_address'      => $request->bank_address,
            'zip_code'          => $request->zip_code,
            'username'          => $request->username,
            'ssn'               => $request->ssn,
        ];

        LinkAccount::create($data);

        return redirect()->route('user.dashboard')->with('success', 'Account linked successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
