<?php

namespace App\Http\Controllers\Dashboard\User;

use App\Http\Controllers\Controller;
use App\Models\Transfer;
use App\Models\TransferCode;
use App\Models\User;
use App\Models\VerificationCode;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class ElectronicTransferController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'withdrawal_method' => ['required', 'max:255'],
            'amount'            => ['required'],
            'beneficiary'       => ['required',  'max:255'],
            'password'          => ['required'],
        ]);

        $user = User::findOrFail(auth()->user()->id);

        if (!Hash::check($request->password, $user->password)) {
            return redirect()->back()->withErrors(['password' => 'The password you entered is incorrect.']);
        }

        if ($user->balance < $request->amount) {
            return redirect()->back()->withErrors(['amount' => 'Insufficient balance.']);
        }

        $referenceId = rand(222222222, 999999999);

        $data = [
            'user_id'           => $user->id,
            'amount'            => $request->amount,
            'withdrawal_method' => $request->withdrawal_method,
            'beneficiary'       => $request->beneficiary,
            'reference_id'      => $referenceId,
            'type'              => 'Electronic Transfer',
        ];

        $transferCode = new TransferCode();
        $transferCode->createTransferCode($referenceId, $user);

        Transfer::create($data);

        return redirect()->route('user.transfer.preview', $referenceId)->with('success', 'Please preview details to continue.');
    }
}
