<?php

namespace App\Http\Controllers\Dashboard\User;

use App\Http\Controllers\Controller;
use App\Models\Transfer;
use App\Models\TransferCode;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class DirectBankTransferController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'bank_name'         => ['required', 'string', 'max:255'],
            'account_number'    => ['required',  'max:255'],
            'account_name'      => ['required', 'string', 'max:255'],
            'phone_number'      => ['nullable',  'max:255'],
            'amount'            => ['required', 'max:255'],
            'swift_code'        => ['nullable',  'max:255'],
            'iban_code'         => ['nullable',  'max:255'],
            'routing_number'    => ['nullable',  'max:255'],
            'password'          => ['required'],
        ]);

        $user = User::findOrFail(auth()->user()->id);

        if (!Hash::check($request->password, $user->password)) {
            return redirect()->back()->withErrors(['password' => 'The password you entered is incorrect.']);
        }

        if ($user->balance < $request->amount) {
            return redirect()->back()->withErrors(['amount' => 'Insufficient balance.']);
        }

        $referenceId = rand(222222222, 999999999);

        $data = [
            'user_id'           => $user->id,
            'bank_name'         => $request->bank_name,
            'account_number'    => $request->account_number,
            'account_name'      => $request->account_name,
            'phone_number'      => $request->phone_number,
            'amount'            => $request->amount,
            'swift_code'        => $request->swift_code,
            'iban_code'         => $request->iban_code,
            'routing_number'    => $request->routing_number,
            'reference_id'      => $referenceId,
            'type'              => 'Direct Bank Transfer',
        ];

        $transferCode = new TransferCode();
        $transferCode->createTransferCode($referenceId, $user);


        Transfer::create($data);

        return redirect()->route('user.transfer.preview', $referenceId)->with('success', 'Please preview details to continue.');
    }
}
