<?php

namespace App\Http\Controllers\Dashboard\User;

use App\Models\User;
use App\Models\Wallet;
use App\Helper\UserHelper;
use App\Traits\ImageUploadTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Deposit;

class DepositController extends Controller
{
    use ImageUploadTrait;
    public function index()
    {
        if (UserHelper::isUserEmailVerified()) {
            return redirect()->route('user.verification')->with('error', 'Unable to verify the authenticity of this account, Please enter verification code sent to your email at the time of registration');
        }

        $user = User::findOrFail(auth()->user()->id);

        $wallets = Wallet::where('status', 1)->get();

        $deposits = Deposit::where('user_id', $user->id)->take(4)->latest()->get();

        $data = [
            'title' => 'Deposit funds',
            'user'  => $user,
            'wallets' => $wallets,
            'deposits' => $deposits
        ];

        return view('dashboard.user.deposit.index', $data);
    }

    public function show($acronyms)
    {
        if (UserHelper::isUserEmailVerified()) {
            return redirect()->route('user.verification')->with('error', 'Unable to verify the authenticity of this account, Please enter verification code sent to your email at the time of registration');
        }

        $user = User::findOrFail(auth()->user()->id);

        $wallet = Wallet::where('acronyms', $acronyms)->first();

        $data = [
            'title' => 'Deposit funds',
            'user'  => $user,
            'wallet' => $wallet
        ];

        return view('dashboard.user.deposit.show', $data);
    }
    public function store(Request $request, $id)
    {
        $request->validate([
            'amount_deposited'  => ['required', 'numeric'],
            'payment_proof'     => ['required', 'image', 'mimes:jpeg,png,jpg,gif,svg', 'max:2048'],
        ]);

        $wallet = Wallet::where('id', $id)->first();

        $proof = $this->uploadFile($request, 'payment_proof', 'uploads/deposits/proofs');

        $data = [
            'user_id'       => auth()->user()->id,
            'reference_id'  => rand(555555555, 999999999),
            'amount'        =>  $request->amount_deposited,
            'method'        => $wallet->name,
            'status'        => 0,
            'proof'         => $proof,
            'wallet_id'     => $id
        ];

        Deposit::create($data);

        return redirect()->back()->with('success', 'Your request have been submitted and will be processed soon');
    }
}
