<?php

namespace App\Http\Controllers\Dashboard\User;

use App\Helper\UserHelper;
use App\Http\Controllers\Controller;
use App\Models\Transaction;
use App\Models\User;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {

        if (UserHelper::isUserEmailVerified()) {
            return redirect()->route('user.verification')->with('error', 'Unable to verify the authenticity of this account, Please enter verification code sent to your email at the time of registration');
        }

        $user = User::findOrFail(auth()->user()->id);

        $transactions = Transaction::where('user_id', $user->id)->orderBy('id', 'desc')->take(3)->get();

        $data = [
            'title' => 'Hello' . ' ' . $user->name,
            'user'  => $user,
            'transactions' => $transactions
        ];

        return view('dashboard.user.index', $data);
    }
}
