<?php

namespace App\Http\Controllers\Dashboard\Master;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;

class MasterDashboardController extends Controller
{
    public function index()
    {
        $adminCounts = User::where('role', 'admin')->count();
        $userCounts = User::where('role', 'user')->count();
        $activeAdminCounts = User::where('role', 'admin')->where('status', 1)->count();

        $data = [
            'title' => 'Master dashboard',
            'adminCounts' => $adminCounts,
            'userCounts'  => $userCounts,
            'activeAdminCounts' => $activeAdminCounts,
        ];

        return view('dashboard.master.index', $data);
    }
}
