<?php

namespace App\Http\Controllers\Dashboard\Master;

use App\Http\Controllers\Controller;
use App\Models\GeneralSetting;
use App\Traits\ImageUploadTrait;
use Illuminate\Http\Request;

class GeneralSettingController extends Controller
{
    use ImageUploadTrait;
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $generalSetting = GeneralSetting::first();

        $data = [
            'title' => 'General settings',
            'generalSetting' => $generalSetting
        ];

        return view('dashboard.master.general-setting.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate([
            'site_name'         => 'required',
            'site_status'       => 'required',
            'contact_email'     => 'required|email',
            'contact_phone'     => 'required',
            'contact_address'   => 'required',
            'currency_name'     => 'required',
            'currency_icon'     => 'required',
            'timezone'          => 'required',
            'pdf_status'        => 'required',
            'site_environment'  => 'required',
            'site_debug'        => 'required|boolean',
            'site_url'          => 'required|url',
            'site_logo'         => ['nullable', 'image', 'mimes:jpeg,png,jpg,gif,svg', 'max:2048'],
        ]);

        $generalSetting = GeneralSetting::first();

        GeneralSetting::updateOrCreate(
            ['id' => $id],
            [
                'site_name'         => $request->site_name,
                'site_status'       => $request->site_status,
                'contact_email'     => $request->contact_email,
                'contact_phone'     => $request->contact_phone,
                'contact_address'   => $request->contact_address,
                'currency_name'     => $request->currency_name,
                'currency_icon'     => $request->currency_icon,
                'timezone'          => $request->timezone,
                'pdf_status'        => $request->pdf_status,
                'site_environment'  => $request->site_environment,
                'site_debug'        => $request->site_debug,
                'site_url'          => $request->site_url,
                'site_logo'         => $this->imageInterventionUpdateImage($request, 'site_logo', 'uploads/logo/', 201, 60, @$generalSetting->site_logo) ?? @$generalSetting->site_logo,
            ]
        );

        return redirect()->back()->with('success', 'General settings updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
