<?php

namespace App\Http\Controllers\Dashboard\Master;

use App\Http\Controllers\Controller;
use App\Models\EmailSetting;
use Illuminate\Http\Request;

class EmailSettingController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $emailSetting = EmailSetting::first();

        $data = [
            'title' => 'Email settings',
            'emailSetting' => $emailSetting
        ];

        return view('dashboard.master.email-setting.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $data = $request->validate([
            'email'      => 'required|email|max:200',
            'host'       => 'required|max:200',
            'username'   => 'required|max:200',
            'password'   => 'required|max:200',
            'port'       => 'required|max:200',
            'encryption' => 'required|max:200',
        ]);

        EmailSetting::updateOrCreate(
            [
                'id' => $id
            ],
            $data
        );

        return redirect()->back()->with('success', 'Email setting has been updated');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
