<?php

namespace App\Http\Controllers\Dashboard\Master;

use App\Http\Controllers\Controller;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class AdminController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {

        $admins = User::where('role', 'admin')->latest()->get();
        $data = [
            'title' => 'Admins',
            'admins' => $admins,
        ];

        return view('dashboard.master.admin.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $data = ['title' => 'Create admins'];

        return view('dashboard.master.admin.create', $data);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name'      => 'required',
            'email'     => 'required|email',
            'password'  => 'required',
        ]);

        $data = [
            'name'      => $request->name,
            'email'     => $request->email,
            'email_verified_at' => Carbon::now(),
            'role' => 'admin',
            'password'  => Hash::make($request->password),
        ];

        User::create($data);

        return redirect()->route('master.admins.index')->with('success', 'Admin created successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $admin = User::where('role', 'admin')->firstOrFail();
        $data = [
            'title' => 'Admin',
            'admin' => $admin,
        ];

        return view('dashboard.master.admin.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate([
            'name'      => 'required',
            'email'     => 'required|email',
            'password'  => 'nullable',
            'status'    => 'required'
        ]);

        $data = [
            'name'      => $request->name,
            'email'     => $request->email,
            'status'    => $request->status
        ];

        if ($request->input('password', false)) {
            $data['password'] = Hash::make($request->password);
        }

        $user = User::findOrFail($id);

        $user->update($data);

        return redirect()->route('master.admins.index')->with('success', 'Admin updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
