<?php

namespace App\Http\Controllers\Dashboard\Admin;

use App\Http\Controllers\Controller;
use App\Models\Transfer;
use App\Models\TransferCode;
use App\Models\User;
use Illuminate\Http\Request;

class UserWithdrawalController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($id)
    {
        $user = User::findOrFail($id);
        $transfers = Transfer::where('user_id', $user->id)->latest()->get();

        $data = [
            'title'         => 'User withdrawals',
            'user'          => $user,
            'transfers'  => $transfers,
        ];

        return view("dashboard.admin.user.withdrawal.index", $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id, string $referenceId)
    {
        $user = User::findOrFail($id);
        $transfer = Transfer::where('user_id', $user->id)->where('reference_id', $referenceId)->first();
        $transferCode = new TransferCode();

        $data = [
            'title'     => 'User withdrawal details',
            'user'      => $user,
            'transfer'  => $transfer,
            'transferCodes' => $transferCode->getTransferVerificationData($referenceId)

        ];

        return view("dashboard.admin.user.withdrawal.show", $data);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function delete(string $id)
    {
        $transfer = Transfer::findOrFail($id);

        $transfer->delete();

        return redirect()->back()->with('success', 'Withdrawal deleted successfully');
    }
}
