<?php

namespace App\Http\Controllers\Dashboard\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Traits\ImageUploadTrait;
use Carbon\Carbon;
use Illuminate\Http\Request;

class UserProfileController extends Controller
{
    use ImageUploadTrait;
    /**
     * Display a listing of the resource.
     */
    public function index(string $id)
    {
        $user = User::findOrFail($id);

        $data = [
            'title' => 'User profile',
            'user'  => $user
        ];

        return view('dashboard.admin.user.profile.index', $data);
    }

    public function update(Request $request, $id)
    {
        $credentials = $request->validate([
            'name'                  => ['nullable', 'string'],
            'email'                 => ['nullable', 'email'],
            'date_of_birth'         => ['required', 'date'],
            'gender'                => ['required', 'string'],
            'marital_status'        => ['required', 'string'],
            'dial_code'             => ['required', 'string'],
            'phone'                 => ['required', 'numeric', 'unique:users,phone,' . $id],
            'professional_status'   => ['required', 'string'],
            'created_at'            => ['required', 'date'],
            'address'               => ['required', 'string'],
            'state'                 => ['required', 'string'],
            'should_transfer_fail'  => ['required', 'numeric'],
            'nationality'           => ['required', 'string'],
            'currency'              => ['required', 'string'],
            'account'               => ['nullable', 'string'],
        ]);

        $user = User::findOrFail($id);
        $user->update($credentials);

        return redirect()->back()->with('success', 'Profile updated successfully');
    }
    public function imageUpdate(Request $request, $id)
    {
        $request->validate([
            'image' => ['required', 'image', 'mimes:jpeg,png,jpg,gif,svg', 'max:2048'],
        ]);

        $user = User::findOrFail($id);
        $user->image = $this->imageInterventionUpdateImage($request, 'image', 'uploads/users/images/', 500, 500, $user->image);
        $user->save();

        return redirect()->back()->with('success', 'Profile image updated successfully');
    }
}
