<?php

namespace App\Http\Controllers\Dashboard\Admin;

use Carbon\Carbon;
use App\Models\User;
use App\Models\UserPlan;
use App\Models\Transaction;
use App\Models\Notification;
use Illuminate\Http\Request;
use App\Traits\ImageUploadTrait;
use App\Http\Controllers\Controller;

class UserPlanController extends Controller
{
    use ImageUploadTrait;
    public function index($id)
    {
        $user = User::findOrFail($id);

        $userPlans = UserPlan::where('user_id', $user->id)->latest()->get();

        $data = [
            'title' => 'User plan',
            'user' => $user,
            'userPlans' => $userPlans
        ];

        return view('dashboard.admin.user.plan.index', $data);
    }
    public function show($id, $userPlanId)
    {
        $user = User::findOrFail($id);

        $userPlan = UserPlan::where('user_id', $user->id)->where('id', $userPlanId)->first();

        $data = [
            'title' => 'User plan details',
            'user' => $user,
            'userPlan' => $userPlan
        ];

        return view('dashboard.admin.user.plan.show', $data);
    }
    public function confirm($id, $userPlanId)
    {
        $user = User::findOrFail($id);

        $userPlan = UserPlan::where('user_id', $user->id)->where('id', $userPlanId)->first();

        $data = [
            'title' => 'User plan confirmation',
            'user' => $user,
            'userPlan' => $userPlan
        ];

        return view('dashboard.admin.user.plan.confirm', $data);
    }
    public function confirmStore(Request $request, $id, $userPlanId)
    {
        $request->validate([
            'earning' => 'required|numeric',
        ]);

        $user = User::findOrFail($id);

        $userPlan = UserPlan::where('user_id', $id)->where('id', $userPlanId)->first();

        $userPlan->status = 1;
        $userPlan->save();

        $user->balance += $userPlan->amount;
        $user->earning += $request->earning;
        $user->save();

        $transactionData = [
            'user_id'          => $user->id,
            'transaction_type' => 'CREDIT',
            'description'      => 'Subscription payment using ' . $userPlan->method . ' for ' . $userPlan->planCategory->name . ' plan',
            'amount'           => $userPlan->amount,
            'current_balance'  => $user->balance,
            'transaction_date' => Carbon::now()->format('Y-m-d'),
            'transaction_time' => Carbon::now()->format('H:i:s'),
            'reference_id'     => $userPlan->reference_id,
            'currency'         => currency('name', $user->id),
            'status'           => 'SUCCESSFUL'
        ];

        Transaction::create($transactionData);

        $notificationMessage = '' . config('app.name') . ' Acct holder:' . $user->name . ' ' . $transactionData['transaction_type'] . ': ' . formatAmount($transactionData['amount'], 'code', $user->id) . ' Desc:' . $transactionData['description'] . ' DT:' . $transactionData['transaction_date'] . ' Available Bal:' . formatAmount($transactionData['current_balance'], 'code', $user->id) . '' . ' Status: Successful';

        $notificationData = [
            'notification_type' => $transactionData['transaction_type'],
            'notification'      => $notificationMessage,
            'user_id'           => $user->id,
        ];

        Notification::create($notificationData);

        return redirect()->route('admin.users.plans.index', $user->id)->with('success', 'Confirmed successfully');
    }
    public function delete($id)
    {
        $userPlan = UserPlan::findOrFail($id);

        $this->deleteFile('uploads/plan/proofs/', $userPlan->proof);

        $userPlan->delete();

        return redirect()->back()->with('success', 'Deleted successfully');
    }
}
