<?php

namespace App\Http\Controllers\Dashboard\Admin;

use App\Http\Controllers\Controller;
use App\Mail\UserNotification;
use App\Models\Notification;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class UserNotificationController extends Controller
{
    public function index($id)
    {
        $user = User::findOrFail($id);
        $notifications = Notification::where('user_id', $user->id)->orderBy('id', 'desc')->get();

        $data = [
            'title' => 'User notifications',
            'user'  => $user,
            'notifications' => $notifications
        ];

        return view('dashboard.admin.user.notification.index', $data);
    }
    public function store(Request $request, $id)
    {
        $request->validate([
            'title'      => 'required',
            'message'    => 'required',
            'notifiable' => 'required',
        ]);

        $user = User::findOrFail($id);

        $data = [
            'notification_type' => $request->title,
            'notification'      => $request->message,
            'user_id'           => $user->id,
        ];

        Notification::create($data);

        $emailData = [
            'title'         => $data['notification_type'],
            'message'       => $data['notification'],
        ];

        switch ($request->notifiable) {
            case 'EMAIL':
                try {
                    Mail::to($user->email)->send(new UserNotification($emailData, $user, config('app.name') . ' ' . 'Notification' . Carbon::now()));
                    session()->flash('email_success', 'Email sent successfully');
                } catch (\Exception $e) {
                    session()->flash('email_error', 'An error occurred while attempting to send the email. Please try again later.');
                }
                break;
        }

        return redirect()->back()->with('success', 'Notification sent successfully');
    }
    public function delete($id)
    {
        $notification = Notification::findOrFail($id);

        $notification->delete();

        return redirect()->back()->with('success', 'Deleted successfully');
    }
}
