<?php

namespace App\Http\Controllers\Dashboard\Admin;

use App\Http\Controllers\Controller;
use App\Models\Deposit;
use App\Models\Notification;
use App\Models\Transaction;
use App\Models\User;
use App\Traits\ImageUploadTrait;
use Carbon\Carbon;
use Illuminate\Http\Request;

class UserDepositController extends Controller
{
    use ImageUploadTrait;
    public function index($id)
    {
        $user = User::findOrFail($id);

        $deposits = Deposit::where('user_id', $user->id)->latest()->get();

        $data = [
            'title' => 'User deposit',
            'user' => $user,
            'deposits' => $deposits
        ];

        return view('dashboard.admin.user.deposit.index', $data);
    }
    public function show($id, $depositId)
    {
        $user = User::findOrFail($id);

        $deposit = Deposit::where('user_id', $user->id)->where('id', $depositId)->first();

        $data = [
            'title' => 'User deposit',
            'user' => $user,
            'deposit' => $deposit
        ];

        return view('dashboard.admin.user.deposit.show', $data);
    }
    public function confirm($id, $depositId)
    {

        $user = User::findOrFail($id);

        $deposit = Deposit::where('user_id', $id)->where('id', $depositId)->first();

        $deposit->status = 1;
        $deposit->save();

        $user->balance += $deposit->amount;
        $user->save();

        $transactionData = [
            'user_id'          => $user->id,
            'transaction_type' => 'CREDIT',
            'description'      => $deposit->method . ' ' . 'deposit method',
            'amount'           => $deposit->amount,
            'current_balance'  => $user->balance,
            'transaction_date' => Carbon::now()->format('Y-m-d'),
            'transaction_time' => Carbon::now()->format('H:i:s'),
            'reference_id'     => $deposit->reference_id,
            'currency'         => currency('name', $user->id),
            'status'           => 'SUCCESSFUL'
        ];

        Transaction::create($transactionData);

        $notificationMessage = '' . config('app.name') . ' Acct holder:' . $user->name . ' ' . $transactionData['transaction_type'] . ': ' . formatAmount($transactionData['amount'], 'code', $user->id) . ' Desc:' . $transactionData['description'] . ' DT:' . $transactionData['transaction_date'] . ' Available Bal:' . formatAmount($transactionData['current_balance'], 'code', $user->id) . '' . ' Status: Successful';

        $notificationData = [
            'notification_type' => $transactionData['transaction_type'],
            'notification'      => $notificationMessage,
            'user_id'           => $user->id,
        ];

        Notification::create($notificationData);

        return redirect()->route('admin.users.deposits.index', $user->id)->with('success', 'Confirmed successfully');
    }
    public function delete($id)
    {
        $deposit = Deposit::findOrFail($id);

        $this->deleteFile('uploads/deposits/proofs/', $deposit->proof);

        $deposit->delete();

        return redirect()->back()->with('success', 'Deleted successfully');
    }
}
