<?php

namespace App\Http\Controllers\Dashboard\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Traits\ImageUploadTrait;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UserController extends Controller
{
    use ImageUploadTrait;
    public function verified()
    {
        $users = User::where('status', 1)->where('role', 'user')->latest()->get();
        $data = [
            'title' => 'Verified users',
            'users' => $users
        ];
        return view('dashboard.admin.user.verified', $data);
    }
    public function unverified()
    {
        $users = User::where('status', 0)->where('role', 'user')->latest()->get();
        $data = [
            'title' => 'Unverified users',
            'users' => $users
        ];
        return view('dashboard.admin.user.verified', $data);
    }
    public function skipVerification(string $id)
    {
        $user = User::findOrFail($id);
        $user->email_verified_at = Carbon::now();
        $user->save();

        return redirect()->back()->with('success', 'Updated successfully');
    }
    public function setVerification(string $id)
    {
        $user = User::findOrFail($id);
        $user->email_verified_at = null;
        $user->save();

        return redirect()->back()->with('success', 'Updated successfully');
    }
    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $user = User::findOrFail($id);

        $this->deleteFile('uploads/users/images/', $user->image);

        $user->delete();

        return redirect()->route('admin.dashboard')->with('success', 'User deleted successfully');
    }
}
