<?php

namespace App\Http\Controllers\Dashboard\Admin;

use App\Models\Wallet;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Traits\ImageUploadTrait;
use App\Http\Controllers\Controller;

class AdminWalletController extends Controller
{
    use ImageUploadTrait;
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $wallets = Wallet::all();
        $data = [
            'title' => 'Wallets',
            'wallets' => $wallets
        ];

        return view("dashboard.admin.wallet.index", $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name'      => ['required', 'string'],
            'acronyms'  => ['required', 'string'],
            'address'   => ['required', 'string'],
            'logo'      => ['nullable', 'image', 'mimes:jpeg,png,jpg,gif,svg', 'max:2048'],
            'qr_code'   => ['nullable', 'image', 'mimes:jpeg,png,jpg,gif,svg', 'max:2048'],
            'status'    => ['required', 'numeric']
        ]);
        $logo = $this->imageInterventionUploadImage($request, 'logo', 'uploads/wallets/logos/', 200, 200);
        $qrCode = $this->imageInterventionUploadImage($request, 'qr_code', 'uploads/wallets/qr_codes/', 500, 500);
        $wallet = new Wallet();
        $wallet->name = $request->name;
        $wallet->acronyms = Str::slug($request->acronyms);
        $wallet->address = $request->address;
        $wallet->logo = $logo ?? null;
        $wallet->qr_code = $qrCode ?? null;
        $wallet->status = $request->status;
        $wallet->save();

        return redirect()->back()->with('success', 'Wallet created successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $wallet = Wallet::findOrFail($id);
        $data = [
            'title' => 'Wallets',
            'wallet' => $wallet,
        ];

        return view("dashboard.admin.wallet.show", $data);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $wallet = Wallet::findOrFail($id);
        $wallets = Wallet::all();
        $data = [
            'title' => 'Wallets',
            'wallet' => $wallet,
            'wallets' => $wallets
        ];

        return view("dashboard.admin.wallet.edit", $data);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate([
            'name'      => ['required', 'string'],
            'acronyms'  => ['required', 'string'],
            'address'   => ['required', 'string'],
            'logo'      => ['nullable', 'image', 'mimes:jpeg,png,jpg,gif,svg', 'max:2048'],
            'qr_code'   => ['nullable', 'image', 'mimes:jpeg,png,jpg,gif,svg', 'max:2048'],
            'status'    => ['required', 'numeric']
        ]);
        $wallet = Wallet::findOrFail($id);
        $logo   = $this->imageInterventionUpdateImage($request, 'logo', 'uploads/wallets/logos/', 200, 200, $wallet->logo);
        $qrCode = $this->imageInterventionUpdateImage($request, 'qr_code', 'uploads/wallets/qr_codes/', 500, 500, $wallet->qr_code);

        $wallet->name = $request->name;
        $wallet->acronyms = Str::slug($request->acronyms);
        $wallet->address = $request->address;
        $wallet->logo = $logo ?? $wallet->logo;
        $wallet->qr_code = $qrCode ?? $wallet->qr_code;
        $wallet->status = $request->status;
        $wallet->save();

        return redirect()->route('admin.wallets.index')->with('success', 'Wallet updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function delete(string $id)
    {
        $wallet = Wallet::findOrFail($id);

        $this->deleteFile('uploads/wallets/logos/', $wallet->logo);
        $this->deleteFile('uploads/wallets/qr_codes/', $wallet->qr_code);

        $wallet->delete();

        return redirect()->back()->with('success', 'Wallet deleted successfully');
    }
}
