<?php

namespace App\Http\Controllers\Dashboard\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\VerificationCode;
use Illuminate\Http\Request;

class AdminVerificationCodeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $verificationCodes = VerificationCode::latest()->get();
        $users = User::where('role', 'user')->latest()->get();

        $data = [
            'title' => 'Registered codes',
            'verificationCodes' => $verificationCodes,
            'users' => $users
        ];

        return view('dashboard.admin.verification-code.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $credentials = $request->validate([
            'name'           => ['required'],
            'description'    => ['required'],
            'length'         => ['required', 'numeric'],
            'nature_of_code' => ['required'],
            'applicable_to'  => ['required']
        ]);

        VerificationCode::create($credentials);

        return redirect()->back()->with('success', 'Verification code created successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $verificationCode = VerificationCode::findOrFail($id);

        $verificationCodes = VerificationCode::latest()->get();

        $users = User::where('role', 'user')->latest()->get();

        $data = [
            'title' => 'Registered codes',
            'verificationCode' => $verificationCode,
            'users' => $users,
            'verificationCodes' => $verificationCodes
        ];

        return view('dashboard.admin.verification-code.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $credentials = $request->validate([
            'name'           => ['required'],
            'description'    => ['required'],
            'length'         => ['required', 'numeric'],
            'nature_of_code' => ['required'],
            'applicable_to'  => ['required']
        ]);

        $verificationCode = VerificationCode::findOrFail($id);

        $verificationCode->update($credentials);

        return redirect()->route('admin.verification-codes.index')->with('success', 'Verification code updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function delete(string $id)
    {
        $verificationCode = VerificationCode::findOrFail($id);

        $verificationCode->delete();

        return redirect()->back()->with('success', 'Verification code deleted successfully');
    }
}
