<?php

namespace App\Http\Controllers\Dashboard\Admin;

use App\Http\Controllers\Controller;
use App\Models\Plan;
use App\Models\PlanCategory;
use Illuminate\Http\Request;

class AdminPlanController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($slug)
    {
        $planCategory = PlanCategory::where('slug', $slug)->firstOrFail();

        $plans = Plan::where('plan_category_id', $planCategory->id)->get();

        $data = [
            'title' => 'Plans',
            'plans' => $plans,
            'planCategory' => $planCategory
        ];

        return view('dashboard.admin.plan-category.plan.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, $slug)
    {
        $request->validate([
            'name' => 'required',
        ]);

        $planCategory = PlanCategory::where('slug', $slug)->firstOrFail();

        $data = [
            'plan_category_id' => $planCategory->id,
            'name' => $request->name,
        ];

        Plan::create($data);

        return redirect()->back()->with('success', 'Plan created successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $plan = Plan::findOrFail($id);

        $plans = Plan::where('id', $plan->id)->get();

        $data = [
            'title' => 'Edit plan',
            'plan'  => $plan,
            'plans' => $plans,
        ];

        return view('dashboard.admin.plan-category.plan.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate([
            'name' => 'required',
        ]);

        $data = [
            'name' => $request->name,
        ];

        $plan = Plan::findOrFail($id);

        $plan->update($data);

        return redirect()->route('admin.plans.index', $plan->planCategory->slug)->with('success', 'Plan updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function delete(string $id)
    {
        $plan = Plan::findOrFail($id);

        $plan->delete();

        return redirect()->back()->with('success', 'Plan deleted successfully');
    }
}
