<?php

namespace App\Http\Controllers\Dashboard\Admin;

use Illuminate\Support\Str;
use App\Models\PlanCategory;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class AdminPlanCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $planCategories = PlanCategory::latest()->get();

        $data = [
            'title' => 'Plan categories',
            'planCategories' => $planCategories
        ];

        return view('dashboard.admin.plan-category.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'price' => 'required|numeric'
        ]);

        $data = [
            'name'  => $request->name,
            'price' => $request->price,
            'slug'  => Str::slug($request->name)
        ];

        PlanCategory::create($data);

        return redirect()->back()->with('success', 'Plan category created successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $planCategories = PlanCategory::where('id', $id)->get();

        $planCategory = PlanCategory::find($id);

        $data = [
            'title'             => 'Edit plan categories',
            'planCategories'    => $planCategories,
            'planCategory'      => $planCategory
        ];

        return view('dashboard.admin.plan-category.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate([
            'name' => 'required',
            'price' => 'required|numeric'
        ]);

        $planCategory = PlanCategory::find($id);

        $data = [
            'name'  => $request->name,
            'price' => $request->price,
            'slug'  => Str::slug($request->name)
        ];

        $planCategory->update($data);

        return redirect()->route('admin.plan-categories.index')->with('success', 'Plan category updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function delete(string $id)
    {
        $planCategory = PlanCategory::find($id);

        $planCategory->delete();

        return redirect()->back()->with('success', 'Plan category deleted successfully');
    }
}
