<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;

class AuthenticatedSessionController extends Controller
{
    /**
     * Display the login view.
     */
    public function create(): View
    {
        $data = ['title' => 'Login account'];
        return view('auth.login', $data);
    }

    /**
     * Handle an incoming authentication request.
     */
    public function store(LoginRequest $request): RedirectResponse
    {
        $request->authenticate();

        $request->session()->regenerate();

        if ($request->user()->role === 'admin') {
            session()->flash('success', 'Login successful');
            return redirect()->intended('/admin/dashboard');
        } elseif ($request->user()->role === 'user') {
            session()->flash('success', 'Login successful');
            return redirect()->intended('/user/dashboard');
        } elseif ($request->user()->role === 'master') {
            session()->flash('success', 'Login successful');
            return redirect()->intended('/master/dashboard');
        }

        return redirect()->intended(route('user.dashboard', absolute: false));
    }

    /**
     * Destroy an authenticated session.
     */
    public function destroy(Request $request): RedirectResponse
    {
        $user = User::findOrFail($request->user()->id);
        $user->last_login_time = Carbon::now();
        $user->save();

        Auth::guard('web')->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect()->route('login')->with('success', 'Logout successful');
    }
}
