<?php

use App\Models\User;

/**
 * Set active menu
 *
 * @param array $routes
 * @return void
 */
function setActiveMenu(array $routes)
{
    // Check if the input is an array
    if (is_array($routes)) {
        // Loop through each route
        foreach ($routes as $route) {
            // Check if the current request route matches the provided route
            if (request()->routeIs($route)) {
                // Return 'active' if the route matches
                return 'active';
            }
        }
    }
}

function currency($type, $id = null)
{

    if (auth()->user()->role == 'user') {
        $user = User::findOrFail(auth()->user()->id);
    } else {
        $user = User::findOrFail($id);
    }

    $explodeCurrency = explode('-', $user->currency);

    switch ($type) {
        case 'name':
            return $explodeCurrency[0];
            break;
        case 'code':
            return $explodeCurrency[1];
        case 'symbol':
            return $explodeCurrency[2];
        default:
            return $explodeCurrency[2];
            break;
    }
}

function formatAmount($amount, $currency = null, $id = null)
{
    if ($currency != null) {
        return currency('symbol', $id) . number_format($amount, 2);
    } else {
        return number_format($amount, 2);
    }
}

function AdminFormatAmount($settings, $amount)
{
    return $settings->currency_icon . number_format($amount, 2);
}
function generateCode($length, $isAlphanumeric = true)
{
    // Define the character set based on the code type
    if ($isAlphanumeric) {
        // If the code type is alphanumeric
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    } else {
        // If the code type is numeric only
        $characters = '0123456789';
    }

    // Define an empty string to store the generated code
    $code = '';

    // Calculate the length of the character set
    $charLength = strlen($characters);

    // Generate the code by selecting random characters from the character set
    for ($i = 0; $i < $length; $i++) {
        // Select a random index within the character set
        $randomIndex = rand(0, $charLength - 1);

        // Get the character at the random index from the character set
        $randomCharacter = $characters[$randomIndex];

        // Append the random character to the code string
        $code .= $randomCharacter;
    }

    return $code;
}
