<?php

namespace App\Helper;

use App\Models\User;

class UserHelper
{
    public static function isUserEmailVerified()
    {
        $user = User::findOrFail(auth()->user()->id);

        if ($user->email_verified_at == null) {
            return true;
        }
        return false;
    }
    public static function generateCode()
    {
        $otp = "";
        for ($i = 0; $i < 6; $i++) {
            $otp .= rand(0, 9);
        }
        return $otp;
    }
    public static function generateTradingAccountNumber($length = 9)
    {
        $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        $accountNumber = 'BTC';

        for ($i = 0; $i < $length - 3; $i++) {
            $accountNumber .= $characters[rand(0, strlen($characters) - 1)];
        }

        return $accountNumber;
    }
}
