<?php

namespace App\Helper;

use App\Models\EmailSetting;


class EmailSettingHelper
{
    public static function config()
    {
        $emailSetting = EmailSetting::first();

        $config = [
            'transport'     => 'smtp',
            'host'          => $emailSetting->host,
            'port'          => $emailSetting->port,
            'encryption'    => $emailSetting->encryption,
            'username'      => $emailSetting->username,
            'password'      => $emailSetting->password,
            'timeout'       => null,
            'local_domain'  => env('MAIL_EHLO_DOMAIN'),
        ];

        config(['mail.mailers.smtp' => $config]);
        config(['mail.from.address' => $emailSetting->email]);
    }
}
